#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char public[0x80];
char private[0x100];

int main(int argc, char *argv[]) {
  if (argc < 2) {
    printf("Please provide an index to get public data\n");
    return 1;
  }

  memset(public, 'p', 0x80);
  memset(private, 'P', 0x100);

  char index = strtol(argv[1], NULL, 0);
  printf("Index is %d, or 0x%02hhx\n", index, index);

  if (index >= -0x40 && index < 0x40) {
    char c;
    char *a;
    asm volatile(
        "lea (%[public], %q[index]), %[a]"
        : [a] "=a" (a)
        : [public] "r" (public + 0x40), [index] "r" (index));
    printf("[ 8-bit] public + 0x40 at               @0x%02hhx, char at               @0x%02hhx\n",
        (unsigned char)(long unsigned int)public + 0x40,
        (unsigned char)(long unsigned int)a);
    printf("[64-bit] public + 0x40 at @0x%016lx, char at @0x%016lx\n",
        (long unsigned int)public + 0x40, (long unsigned int)a);
    asm volatile(
        "mov (%[public], %q[index]), %[c]\n"
        : [c] "=r" (c), [a] "=a" (a)
        : [public] "r" (public + 0x40), [index] "r" (index));
    printf("char '%c'\n", c);
  } else {
    printf("WTF\n");
  }

  return 0;
}
