#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char private[0x100];
char public[0x100];

int main(int argc, char *argv[]) {
  if (argc < 2) {
    printf("Please provide an index to get public data\n");
    return 1;
  }

  memset(private, 'P', 0x100);
  memset(public, 'p', 0x100);

  // char index = strtol(argv[1], NULL, 0);
  unsigned char index = strtol(argv[1], NULL, 0);
  printf("Index is %d, or 0x%02hhx\n", index, index);

  if (index < 0x100) {
    printf("[64-bit] public + index at @0x%016lx, public at @0x%016lx\n",
        (long unsigned int)(public + index), (long unsigned int)(public));
    printf("char '%c'\n", public[(long unsigned int)index]);
  } else {
    printf("WTF\n");
  }

  return 0;
}
