#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char private[0x100];
char public[0x100];

int main(int argc, char *argv[]) {
  if (argc < 3) {
    printf("Please provide 2 indexes to get public data\n");
    return 1;
  }

  memset(private, 'P', 0x100);
  memset(public, 'p', 0x100);

  long int index1 = strtoll(argv[1], NULL, 0);
  long int index2 = strtoll(argv[2], NULL, 0);
  printf("index1 is 0x%016lx index2 is 0x%016lx 0x%016lx\n",
      index1, index2, index1 + index2);

  if (index1 >= 0 && index2 >= 0) {
    printf("[64-bit] public + index at @0x%016lx, public at @0x%016lx\n",
        (long unsigned int)(public + index1 + index2), (long unsigned int)(public));
    printf("char '%c'\n", public[(long unsigned int)index1 + index2]);
  } else {
    printf("WTF\n");
  }

  return 0;
}
